program FINITEDIFFERS;
{--------------------------------------------------------------------}
{  Alg10'1.pas   Pascal program for implementing Algorithm 10.1      }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 10.1 (Finite-Difference Solution for the Wave Equation).}
{  Section   10.1, Hyperbolic Equations, Page 507                    }
{--------------------------------------------------------------------}

  uses
    crt;

  const
    Pi = 3.14159265;
    GNmax = 630;
    MaxN = 26;
    MaxM = 101;
    FunMax = 9;

  type
    MATRIX = array[1..MaxN, 1..MaxM] of real;
    LETTER = string[8];
    States = (Changes, Done, Working);
    DoSome = (Go, Stop);
    LETTERS = string[200];

  var
    FunType, GNpts, Inum, M, Mend, Meth, N, Order, Sub: integer;
    A, B, C, Rnum, Y0: real;
    Ans: CHAR;
    U: MATRIX;
    State: States;
    DoMo: DoSome;
    Mess: LETTERS;

  function F (X: real): real;
  begin
    case FunType of
      1: 
        F := SIN(Pi * X) + SIN(2 * Pi * X);
    end;
  end;

  function G (X: real): real;
  begin
    case FunType of
      1: 
        G := 0;
    end;
  end;

  procedure PRINTFUNCTION (FunType: integer);
  begin
    case FunType of
      1: 
        begin
          WRITELN;
          WRITELN('          The boundary functions are:');
          WRITELN;
          WRITELN('           u(x,0)  =  f(x) =  SIN(Pi * X) + SIN(2 * Pi * X)');
          WRITELN;
          WRITELN('          u (x,0)  =  g(x) =  0');
          WRITELN('           t');
        end;
    end;
  end;

  procedure FineDiff ({FUNCTION F(x,t:real), G(x,t:real): real;}
                  A, B, C: real; var N, M: integer; var U: MATRIX);
    var
      I, J: integer;
      H, K, R, R2, R22, S1, S2: real;

    function Fi (I: integer): real;
    begin
      Fi := F(H * (I - 1));
    end;

    function Gi (I: integer): real;
    begin
      Gi := G(H * (I - 1));
    end;

  begin                                       {The main program FineDiff}
    H := A / (N - 1);
    K := B / (M - 1);
    R := C * K / H;
    R2 := R * R;
    R22 := R * R / 2;
    S1 := 1 - R * R;
    S2 := 2 - 2 * R * R;
    for J := 1 to M do
      begin
        U[1, J] := 0;
        U[N, J] := 0;
      end;
    for I := 2 to N - 1 do
      begin
        U[I, 1] := Fi(I);
        U[I, 2] := S1 * Fi(I) + K * Gi(I) + R22 * (Fi(I + 1) + Fi(I - 1));
      end;
    for J := 3 to M do
      for I := 2 to N - 1 do
        U[I, J] := S2 * U[I, J - 1] + R2 * (U[I - 1, J - 1] + U[I + 1, J - 1]) - U[I, J - 2];
  end;

  procedure MESSAGE (var Meth: integer);
    var
      K: integer;
  begin
    CLRSCR;
    WRITELN('                      SOLUTION OF HYPERBOLIC EQUATIONS');
    WRITELN;
    Meth := 1;
  end;

  procedure INPUT (var FunType: integer);
    var
      K: integer;
      Ans: LETTER;
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITELN('          The finite difference method is used to solve the wave equation');
    WRITELN;
    WRITELN('                                    2          ');
    WRITELN('                     u  (x,t)   =  c  u  (x,t)');
    WRITELN('                      tt               xx');
    WRITELN;
    WRITELN('          with   u(0,t) = 0  and  u(a,t) = 0   for 0<=t<=B.');
    WRITELN;
    WRITELN;
    WRITELN('          and   u(x,0)  =  f(x)   and  u (x,0)  =  g(x)   for  0 < x < A.');
    WRITELN('                                        t');
    WRITELN;
    WRITELN;
    WRITELN('          A numerical approximation is computed over the rectangle');
    WRITELN;
    WRITELN('                             0<=x<=A.');
    WRITELN('                             0<=t<=B.');
    WRITELN;
    WRITELN('          You must supply the endpoints for the intervals.');
    WRITELN;
    WRITELN;
    WRITE('          Press the <ENTER> key. ');
    READLN(Ans);
    WRITELN;
    FunType := 1;
  end;

  procedure EPOINTS (var A, B, C: real; var N, M: integer; var State: STATES);
    type
      STATUS = (Change, Enter, Done);
      LETTER = string[1];
    var
      I: integer;
      Valu: real;
      Resp: CHAR;
      Stat: STATUS;
  begin
    Stat := Enter;
    if State = Changes then
      Stat := Change;
    while (Stat = Enter) or (Stat = Change) do
      begin
        CLRSCR;
        WRITELN;
        WRITE('                 ');
        PRINTFUNCTION(FunType);
        WRITELN;
        WRITELN;
        if (Stat = Enter) then
          begin
            Mess := '     For the interval [0,A], ENTER the endpoint   A = ';
            WRITE(Mess);
            READLN(A);
            WRITELN;
            Mess := '     For the interval [0,B], ENTER the endpoint   B = ';
            WRITE(Mess);
            READLN(B);
            WRITELN;
            Mess := '                             ENTER the constant   C = ';
            WRITE(Mess);
            READLN(C);
            WRITELN;
            Mess := '                      ENTER the number of steps   N = ';
            WRITE(Mess);
            READLN(N);
            if N < 2 then
              N := 2;
            if N > 25 then
              N := 25;
            WRITELN;
            Mess := '                      ENTER the number of steps   M = ';
            WRITE(Mess);
            READLN(M);
            if M < 2 then
              M := 2;
            if M > 100 then
              M := 100;
          end
        else
          begin
            WRITELN('     For the interval [0,A], the endpoint  is     A =', A : 8 : 4);
            WRITELN;
            WRITELN;
            WRITELN('     For the interval [0,B], the endpoint  is     B =', B : 8 : 4);
            WRITELN;
            WRITELN;
            WRITELN('                              The constant is     C =', C : 8 : 4);
            WRITELN;
            WRITELN;
            WRITELN('                      The number of steps  is     N =  ', N : 2);
            WRITELN;
            WRITELN;
            WRITELN('                      The number of steps  is     M =  ', M : 2);
          end;
        WRITELN;
        WRITELN;
        WRITE('                      Want to make a change ?    <Y/N>  ');
        READLN(Resp);
        WRITELN;
        if (Resp = 'Y') or (Resp = 'y') then
          begin
            Stat := Change;
            CLRSCR;
            WRITELN;
            WRITE('                 ');
            PRINTFUNCTION(FunType);
            WRITELN;
            WRITELN('     [0,A] the current endpoint is A =', A : 8 : 4);
            Mess := '     ENTER  the NEW left  endpoint A =  ';
            WRITE(Mess);
            READLN(A);
            WRITELN;
            WRITELN('     [0,B] the current endpoint is B =', B : 8 : 4);
            Mess := '     ENTER  the NEW right endpoint B =  ';
            WRITE(Mess);
            READLN(B);
            WRITELN;
            WRITELN('        The   current constant is  C =', C : 8 : 4);
            Mess := '     Now  ENTER the NEW  constant  C =  ';
            WRITE(Mess);
            READLN(C);
            WRITELN;
            WRITELN('     The  current value of  N  is  N =  ', N : 1);
            Mess := '     Now  ENTER  the NEW value of  N =  ';
            WRITE(Mess);
            READLN(N);
            if (N < 2) then
              N := 2;
            if (N > 25) then
              N := 25;
            WRITELN;
            WRITELN('     The  current value of  M  is  M =  ', M : 1);
            Mess := '     Now  ENTER  the NEW value of  M =  ';
            WRITE(Mess);
            READLN(M);
            if (M < 2) then
              M := 2;
            if (M > 100) then
              M := 100;
          end
        else
          Stat := Done;
      end;
  end;

  procedure RESULTS (FunType: integer; U: MATRIX; N, M: integer);
    var
      I, J: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITE('      ');
    PRINTFUNCTION(FunType);
    WRITELN;
    WRITELN;
    WRITELN('          u(x ,t )   .....    u(x   ,t )');
    WRITELN('             2  j                N-1  j');
    WRITELN('--------------------------------------------------------------------------------');
    WRITELN;
    for J := 1 to M do
      begin
        for I := 2 to N - 1 do
          WRITE(U[I, J] : 10 : 6);
        WRITELN;
        if J mod 21 = 0 then
          begin
            WRITELN;
            WRITE('                  Press the <ENTER> key.  ');
            READLN(Ans);
            WRITELN;
            WRITELN;
          end;
      end;
    WRITELN;
    WRITE('                  Press the <ENTER> key.  ');
    READLN(Ans);
    WRITELN;
  end;

begin                                            {Begin Main Program}
  Meth := 1;
  FunType := 1;
  A := 0;
  B := 1;
  Y0 := 0;
  M := 1;
  State := Working;
  while Meth <> 0 do
    begin
      MESSAGE(Meth);
      DoMo := Go;
      while DoMo = Go do
        begin
          INPUT(FunType);
          while (State = Working) or (State = Changes) do
            begin
              EPOINTS(A, B, C, N, M, State);
              case Meth of
                1: 
                  FineDiff(A, B, C, N, M, U);
                2: 
                  C := 1;      { FiniteDiff(A, B, Alpha, Beta, M, T, X); }
              end;
              RESULTS(FunType, U, N, M);
              WRITELN;
              WRITELN;
              WRITE('     Want to use a  different  initial condition ?  <Y/N>  ');
              READLN(Ans);
              WRITELN;
              if (Ans <> 'Y') and (Ans <> 'y') then
                State := Done
              else
                State := Changes;
            end;
          WRITELN;
          WRITE('     Want to  change  the  differential equation ?  <Y/N>  ');
          READLN(Ans);
          WRITELN;
          if (Ans <> 'Y') and (Ans <> 'y') then
            DoMo := Stop
          else
            State := Changes;
        end;
      Mess := 'Want to try another method of approximation ?  <Y/N>  ';
      Ans := 'N';
      if (Ans <> 'Y') and (Ans <> 'y') then
        Meth := 0
      else
        State := Changes;
    end;
end.                                            {End of Main Program}

